/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.common.CVUException;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.VoteDiskInfo;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.RunGenericCommand;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.sTaskFreeSpace;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.TypeFinder;
import oracle.ops.verification.framework.storage.USMDevInfo;
import oracle.ops.verification.framework.storage.USMDevInfoException;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.GenericUtil;
import oracle.ops.verification.util.ParsingException;

public class TaskUSMUdevChecks
extends Task {
    private String m_owner = null;
    private String m_group = null;
    private String m_perms = null;
    private StorageEntity m_stEntity = StorageEntity.USM;
    private String[] m_UdevCheckPaths = new String[0];
    private String[] m_UdevCheckFileSystems = new String[0];
    private String m_stEntityString = null;
    private boolean m_hdrPrinted = false;
    private static final String TAG_USMDEV = "USMDEV";
    private static final String STRING_CSS_USER = "CSS_USER";
    private String m_asmDiskOwner = null;
    private String m_asmDiskGroup = null;
    private String m_asmDiskPermissions = null;

    public TaskUSMUdevChecks(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskUSMUdevChecks(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskUSMUdevChecks(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    @Override
    public boolean performTask() {
        if (Trace.isTraceEnabled()) {
            Trace.out((int)5, (String)"Performing udev checks for USM ");
        }
        switch (this.m_stEntity) {
            case USM: {
                this.m_stEntityString = s_msgBundle.getMessage("9803", false);
                break;
            }
            case OCR: {
                this.m_stEntityString = s_msgBundle.getMessage("9804", false);
                break;
            }
            case VDISK: {
                this.m_stEntityString = s_msgBundle.getMessage("9805", false);
                break;
            }
            case ASM: {
                this.m_stEntityString = s_msgBundle.getMessage("9812", false);
                break;
            }
            default: {
                this.m_stEntityString = s_msgBundle.getMessage("9803", false);
            }
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5191", false, (Object[])new String[]{this.m_stEntityString}));
        this.performUdevChecks();
        if (this.m_resultSet.allSuccess()) {
            Trace.out((int)5, (String)"ResultSet shows alll Success");
            ReportUtil.printResult(s_msgBundle.getMessage("5178", false, (Object[])new String[]{this.m_stEntityString}));
            ReportUtil.sureblankln();
            return true;
        }
        Trace.out((String)"ResultSet shows at least one failure");
        ReportUtil.printResult(s_msgBundle.getMessage("5179", false, (Object[])new String[]{this.m_stEntityString}));
        ReportUtil.sureblankln();
        return false;
    }

    private void performUdevChecks() {
        String cmdOut;
        Result result;
        String node;
        Enumeration e;
        Hashtable t;
        Command[] cmdArray;
        String localName;
        Trace.out((int)2, (String)"Entry");
        if (!this.getStorageAttributes()) {
            Trace.out((String)"Failed to get storage attributes. Cannot proceed with Udev attributes checks.");
            ReportUtil.printError(s_msgBundle.getMessage("9806", true));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return;
        }
        try {
            localName = VerificationUtil.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            Trace.out((String)("UNKNOWNHOSTEXCEPTION: \n" + uhe));
            String errMsg = s_msgBundle.getMessage("0002", true);
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
            ReportUtil.printError(errMsg);
            return;
        }
        ClusterInfo ci = null;
        VoteDiskInfo[] vdiskArr = null;
        String[] ocrLocations = null;
        ArrayList<String> pathList = new ArrayList<String>();
        ArrayList<String> fileSystemList = new ArrayList<String>();
        StorageInfo stInfo = null;
        String voteLoc = null;
        String ocrLoc = null;
        String fileSystem = null;
        String savFileSystem = null;
        int i = 0;
        if (this.isOCRUDevCheck()) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Doing OCRUdevCheck");
            }
            ResultSet resultSet = new ResultSet();
            ocrLocations = VerificationUtil.getOCRLocations(VerificationUtil.getCRSActiveVersionObj(), resultSet);
            for (i = 0; i < ocrLocations.length; ++i) {
                ocrLoc = ocrLocations[i];
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("OCR location Path " + i + " = " + ocrLoc));
                }
                if (ocrLoc == null || VerificationUtil.isASMPath(ocrLoc)) continue;
                try {
                    stInfo = new TypeFinder().getStorageInstance(ocrLoc);
                }
                catch (StorageException e2) {
                    Trace.out((String)("StorageException attempting to get storage type for: " + ocrLoc));
                    continue;
                }
                fileSystem = ocrLoc;
                while (stInfo.getType() == 5) {
                    sTaskFreeSpace sTask = new sTaskFreeSpace();
                    cmdArray = new Command[1];
                    ResultSet freeSpcRsltSet = new ResultSet();
                    String cmd = sTask.getCommand(ocrLoc);
                    cmdArray[0] = new RunGenericCommand(localName, cmd);
                    boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, freeSpcRsltSet);
                    t = freeSpcRsltSet.getResultTable();
                    e = t.keys();
                    fileSystem = "UNKNOWN";
                    while (e.hasMoreElements()) {
                        node = (String)e.nextElement();
                        result = (Result)t.get(node);
                        if (result.getStatus() != 1) continue;
                        cmdOut = VerificationUtil.fetchVerificationValue((String)result.getResultInfoSet().firstElement());
                        fileSystem = sTask.getData(cmdOut, 0);
                        if (!Trace.isLevelEnabled((int)5)) continue;
                        Trace.out((String)("Parsing ocrLoc: " + ocrLoc + " to: " + fileSystem));
                    }
                    if (savFileSystem == null) {
                        savFileSystem = fileSystem;
                    } else {
                        if (fileSystem.contentEquals(savFileSystem)) break;
                        savFileSystem = fileSystem;
                    }
                    try {
                        stInfo = new TypeFinder().getStorageInstance(fileSystem);
                    }
                    catch (StorageException se) {
                        Trace.out((String)("StorageException getting storage type for: " + fileSystem));
                        break;
                    }
                }
                if (stInfo.getType() != 1) continue;
                pathList.add(ocrLoc);
                fileSystemList.add(fileSystem);
            }
        } else if (this.isVDiskUDevCheck()) {
            String crsHome;
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Doing VDiskUdevCheck");
            }
            if ((crsHome = VerificationUtil.getCRSHome()) == null) {
                String errMsg = s_msgBundle.getMessage("5301", true);
                ErrorDescription errorDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addResult(this.m_nodeList, 2);
                this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
                ReportUtil.printError(errMsg);
                return;
            }
            Trace.out((String)("crshome obtained is :" + crsHome));
            try {
                boolean votingDiskListObtained = false;
                boolean isBigCluster = this.m_nodeMgr.isBigCluster();
                if (isBigCluster && this.m_nodeMgr.isActiveRimNode(localName)) {
                    vdiskArr = VerificationUtil.getVoteDiskListFromNode(crsHome, this.m_nodeList[0]);
                    votingDiskListObtained = true;
                    Trace.out((String)"obtained vote disk list from hub");
                }
                if (!votingDiskListObtained) {
                    ci = new ClusterInfo(VerificationUtil.getCRSHome());
                    vdiskArr = ci.getVoteDiskLocations(VerificationUtil.getCRSActiveVersionObj());
                }
            }
            catch (ClusterInfoException cie) {
                Trace.out((String)"ClusterInfoException trying to get voting disk locations");
                ReportUtil.printError(s_msgBundle.getMessage("5197", true) + cie.getMessage());
                this.m_resultSet.addResult(this.m_nodeList, 2);
                return;
            }
            catch (VerificationException ve) {
                this.m_resultSet.addResult(localName, 2);
                ErrorDescription errDesc = new ErrorDescription(ve.getMessage());
                this.m_resultSet.addErrorDescription(errDesc);
                Trace.out((String)("verificaiton failed :" + errDesc.getErrorMessage()));
                ReportUtil.printError(errDesc.getErrorMessage());
                return;
            }
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("No of Voting disks found = " + vdiskArr.length));
            }
            for (i = 0; i < vdiskArr.length; ++i) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("Voting Disk Path " + i + " = " + vdiskArr[i].getPath()));
                }
                if (vdiskArr[i].isASMPath() == 1) continue;
                voteLoc = vdiskArr[i].getPath();
                try {
                    stInfo = new TypeFinder().getStorageInstance(voteLoc);
                }
                catch (StorageException e3) {
                    Trace.out((String)("StorageException attempting to get storage type for: " + voteLoc));
                    continue;
                }
                fileSystem = voteLoc;
                while (stInfo.getType() == 5) {
                    sTaskFreeSpace sTask = new sTaskFreeSpace();
                    cmdArray = new Command[1];
                    ResultSet freeSpcRsltSet = new ResultSet();
                    String cmd = sTask.getCommand(voteLoc);
                    cmdArray[0] = new RunGenericCommand(localName, cmd);
                    boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, freeSpcRsltSet);
                    t = freeSpcRsltSet.getResultTable();
                    e = t.keys();
                    fileSystem = "UNKNOWN";
                    while (e.hasMoreElements()) {
                        node = (String)e.nextElement();
                        result = (Result)t.get(node);
                        if (result.getStatus() != 1) continue;
                        cmdOut = VerificationUtil.fetchVerificationValue((String)result.getResultInfoSet().firstElement());
                        fileSystem = sTask.getData(cmdOut, 0);
                        if (!Trace.isLevelEnabled((int)5)) continue;
                        Trace.out((String)("Parsing VoteLoc: " + voteLoc + " to: " + fileSystem));
                    }
                    if (savFileSystem == null) {
                        savFileSystem = fileSystem;
                    } else {
                        if (fileSystem.contentEquals(savFileSystem)) break;
                        savFileSystem = fileSystem;
                    }
                    try {
                        stInfo = new TypeFinder().getStorageInstance(fileSystem);
                    }
                    catch (StorageException se) {
                        Trace.out((String)("StorageException getting storage type for: " + fileSystem));
                        break;
                    }
                }
                if (stInfo.getType() != 1) continue;
                pathList.add(voteLoc);
                fileSystemList.add(fileSystem);
            }
        } else if (this.isASMDiskUDevCheck() && this.m_UdevCheckPaths != null) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Doing ASMDiskUdevCheck");
            }
            for (i = 0; i < this.m_UdevCheckPaths.length; ++i) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("Disk Path " + i + " = " + this.m_UdevCheckPaths[i]));
                }
                try {
                    stInfo = new TypeFinder().getStorageInstance(this.m_UdevCheckPaths[i]);
                }
                catch (StorageException e4) {
                    continue;
                }
                fileSystem = this.m_UdevCheckPaths[i];
                while (stInfo.getType() == 5) {
                    sTaskFreeSpace sTask = new sTaskFreeSpace();
                    Command[] cmdArray2 = new Command[1];
                    ResultSet freeSpcRsltSet = new ResultSet();
                    String cmd = sTask.getCommand(this.m_UdevCheckPaths[i]);
                    cmdArray2[0] = new RunGenericCommand(localName, cmd);
                    boolean cmdResult = new GlobalHandler().submit(cmdArray2, 0, freeSpcRsltSet);
                    Hashtable t2 = freeSpcRsltSet.getResultTable();
                    Enumeration e5 = t2.keys();
                    fileSystem = "UNKNOWN";
                    while (e5.hasMoreElements()) {
                        String node2 = (String)e5.nextElement();
                        Result result2 = (Result)t2.get(node2);
                        if (result2.getStatus() != 1) continue;
                        String cmdOut2 = VerificationUtil.fetchVerificationValue((String)result2.getResultInfoSet().firstElement());
                        fileSystem = sTask.getData(cmdOut2, 0);
                        if (!Trace.isLevelEnabled((int)5)) continue;
                        Trace.out((String)("Parsing Disk location: " + this.m_UdevCheckPaths[i] + " to: " + fileSystem));
                    }
                    if (savFileSystem == null) {
                        savFileSystem = fileSystem;
                    } else {
                        if (fileSystem.contentEquals(savFileSystem)) break;
                        savFileSystem = fileSystem;
                    }
                    try {
                        stInfo = new TypeFinder().getStorageInstance(fileSystem);
                    }
                    catch (StorageException se) {
                        Trace.out((String)("StorageException getting storage type for: " + fileSystem));
                        break;
                    }
                }
                if (stInfo.getType() != 1) continue;
                Trace.out((String)("Using path: '" + this.m_UdevCheckPaths[i] + "' for UDEV check"));
                pathList.add(this.m_UdevCheckPaths[i]);
                fileSystemList.add(fileSystem);
            }
        }
        Vector nonMapperDevs = new Vector();
        for (int j = 0; j < pathList.size(); ++j) {
            if (((String)pathList.get(j)).matches("^/+dev/+mapper\\S*") || ((String)pathList.get(j)).matches("^/+dev/+mpath\\S*")) continue;
            nonMapperDevs.add(pathList.get(j));
        }
        this.m_UdevCheckPaths = nonMapperDevs.toArray(new String[nonMapperDevs.size()]);
        this.m_UdevCheckFileSystems = fileSystemList.toArray(new String[fileSystemList.size()]);
        if (this.m_UdevCheckPaths.length == 0) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"m_UdevCheckPaths is empty!!");
            }
            this.m_resultSet.addResult(this.m_nodeList, 1);
            return;
        }
        ResultSet udevResultSet = new ResultSet();
        this.getUdevAttributes(this.m_nodeList, udevResultSet);
        this.m_resultSet.uploadResultSet(udevResultSet);
        if (udevResultSet.anySuccess()) {
            if (this.isUSMUDevCheck()) {
                this.reportUdevCheckResult(udevResultSet);
            } else if (this.isAnyLocationOnDisk()) {
                this.reportUdevPathCheckResult(udevResultSet);
            }
        }
    }

    private boolean getStorageAttributes() {
        switch (this.m_stEntity) {
            case USM: {
                this.m_owner = VerificationUtil.getUSMDeviceOwner();
                try {
                    this.m_group = VerificationUtil.getASMAdminGroup(null);
                }
                catch (CVUException ce) {
                    Trace.out((String)("Exception occured while getting ASM admin group ::" + ce.getMessage()));
                    ReportUtil.printError(ce.getMessage());
                    return false;
                }
                this.m_perms = this.getUSMDevPerms();
                break;
            }
            case OCR: {
                this.m_owner = VerificationUtil.getOCROwner();
                this.m_group = this.getOCRGroup();
                this.m_perms = VerificationUtil.getOCRPermissions();
                break;
            }
            case VDISK: {
                this.m_owner = TaskUSMUdevChecks.getVDiskOwner();
                this.m_group = this.getVDiskGroup();
                this.m_perms = VerificationUtil.getVDiskPermissions();
                break;
            }
            case ASM: {
                this.m_owner = this.getASMDiskOwner();
                this.m_group = this.getASMDiskGroup();
                this.m_perms = this.getASMDiskPermissions();
                break;
            }
        }
        return this.m_owner != null && this.m_group != null && this.m_perms != null;
    }

    private void reportUdevCheckResult(ResultSet resultSet) {
        this.reportUdevCheckResult(resultSet, null);
    }

    private void reportUdevCheckResult(ResultSet resultSet, String path2Check) {
        Hashtable t = resultSet.getResultTable();
        Enumeration e = t.keys();
        String hdrName = s_msgBundle.getMessage("5180", false);
        String hdrOwner = s_msgBundle.getMessage("5181", false);
        String hdrGroup = s_msgBundle.getMessage("5182", false);
        String hdrPerms = s_msgBundle.getMessage("5183", false);
        String hdrResult = s_msgBundle.getMessage("5192", false);
        boolean pathSpecified = path2Check != null;
        String distID = VerificationUtil.getUniqueDistributionID();
        USMDevInfo usmDev = null;
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                Vector udevVect = result.getResultInfoSet();
                if (udevVect.size() > 0) {
                    int j = 0;
                    int i = udevVect.size();
                    while (j < udevVect.size()) {
                        Boolean pathFoundinUdev = false;
                        if (Trace.isLevelEnabled((int)5)) {
                            Trace.out((String)("udevVect size: " + udevVect.size() + " i: " + i + " j: " + j));
                        }
                        if (distID.startsWith("SUSE")) {
                            usmDev = (USMDevInfo)udevVect.get(j);
                            if (Trace.isLevelEnabled((int)5)) {
                                Trace.out((String)("Getting SUSE udevVect object: " + j));
                            }
                        } else {
                            usmDev = (USMDevInfo)udevVect.get(i - 1);
                            if (Trace.isLevelEnabled((int)5)) {
                                Trace.out((String)("Getting udevVect object: " + (i - 1)));
                            }
                        }
                        if (pathSpecified) {
                            pathFoundinUdev = usmDev.match(path2Check);
                        }
                        if (Trace.isLevelEnabled((int)5)) {
                            Trace.out((String)("Found usmDev: Name: '" + usmDev.getName() + "' Owner: '" + usmDev.getOwner() + "' Group: '" + usmDev.getGroup() + "' Permissions: '" + usmDev.getPerms() + "'\n pathSecified: '" + pathSpecified + "' pathFoundinUdev: '" + pathFoundinUdev + "'"));
                        }
                        if (!pathSpecified || pathSpecified && pathFoundinUdev.booleanValue()) {
                            Vector<String> unmatch = new Vector<String>();
                            boolean match = this.compareAttrib(usmDev, unmatch);
                            if (match) {
                                Trace.out((int)5, (String)("Check for device " + usmDev.getName() + " passed."));
                                if (!this.m_hdrPrinted) {
                                    this.m_hdrPrinted = true;
                                    ReportUtil.writeColHeaders(hdrName, hdrOwner, hdrGroup, hdrPerms, hdrResult);
                                }
                                ReportUtil.writeRecord(usmDev.getName(), usmDev.getOwner(), usmDev.getGroup(), usmDev.getPerms(), ReportUtil.PASSED);
                                break;
                            }
                            Trace.out((int)5, (String)("Check for device " + usmDev.getName() + " failed."));
                            String nodeHdr = s_msgBundle.getMessage("8058", false) + ": " + node;
                            ReportUtil.sureprintln(nodeHdr);
                            String udevFile = usmDev.getFile();
                            String udevRule = usmDev.getRule();
                            String msg = s_msgBundle.getMessage("5184", true, (Object[])new String[]{node + ":" + (pathSpecified ? path2Check : usmDev.getName()), unmatch.toString(), udevFile, udevRule});
                            ReportUtil.sureprintln(msg);
                            ErrorDescription errorDesc = new ErrorDescription(msg);
                            this.m_resultSet.addResult(node, 3);
                            this.m_resultSet.addErrorDescription(node, errorDesc);
                            break;
                        }
                        ++j;
                        --i;
                    }
                    ReportUtil.blankln();
                    continue;
                }
                Trace.out((int)5, (String)("No udev entries found on node " + node));
                ReportUtil.sureprintln(s_msgBundle.getMessage("5185", true, (Object[])new String[]{node}));
                this.m_resultSet.addResult(node, 3);
                continue;
            }
            Trace.out((int)5, (String)("Check for UDev device entries failed on node " + node));
            ReportUtil.sureprintln(s_msgBundle.getMessage("5186", true, (Object[])new String[]{node}));
            this.m_resultSet.addResult(node, 2);
        }
    }

    private boolean isAnyLocationOnDisk() {
        Vector<String> diskList = new Vector<String>();
        StorageInfo stInfo = null;
        String localNode = null;
        try {
            localNode = VerificationUtil.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            localNode = new String("LocalNode");
        }
        for (String path2Check : this.m_UdevCheckPaths) {
            if (VerificationUtil.isASMPath(path2Check)) {
                if (!Trace.isLevelEnabled((int)5)) continue;
                Trace.out((String)("Skipping ASM path: " + path2Check));
                continue;
            }
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Checking storage type for location " + path2Check));
            }
            try {
                stInfo = new TypeFinder().getStorageInstance(path2Check);
            }
            catch (StorageException e) {
                Trace.out((String)("StorageException attempting to get storage type for " + path2Check));
                ReportUtil.sureprintln(s_msgBundle.getMessage("9800", true, (Object[])new String[]{path2Check}) + LSEP + e.getMessage());
                ReportUtil.sureblankln();
                this.m_resultSet.addResult(localNode, 2);
                continue;
            }
            if (stInfo.getType() == 1) {
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)("Location " + path2Check + " is of type DISK"));
                }
                diskList.add(path2Check);
                continue;
            }
            Trace.out((String)("Storage " + path2Check + "is not of type DISK, skipping Udev checks"));
        }
        if (diskList.size() > 0) {
            this.m_UdevCheckPaths = diskList.toArray(new String[diskList.size()]);
            return true;
        }
        return false;
    }

    private void reportUdevPathCheckResult(ResultSet resultSet) {
        for (String path2Check : this.m_UdevCheckPaths) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Checking and reporting result for path " + path2Check));
            }
            ReportUtil.sureprintln(s_msgBundle.getMessage("5198", false, (Object[])new String[]{path2Check}));
            this.reportUdevCheckResult(resultSet, path2Check);
        }
    }

    private boolean compareAttrib(USMDevInfo usmDev, Vector<String> unmatch) {
        boolean match = true;
        String Found = s_msgBundle.getMessage("0052", false);
        String Expected = s_msgBundle.getMessage("0053", false);
        if (!usmDev.getOwner().equals(this.m_owner)) {
            Trace.out((int)5, (String)("Owners NOT equal: usmDev '" + usmDev.getOwner() + "' m_owner '" + this.m_owner + "'"));
            match = false;
            unmatch.add(new String(s_msgBundle.getMessage("5181", false) + ": " + Found + "'" + usmDev.getOwner() + "' " + Expected + "'" + this.m_owner + "'"));
        }
        if (!usmDev.getGroup().equals(this.m_group)) {
            Trace.out((int)5, (String)("Groups NOT equal: usmDev '" + usmDev.getGroup() + "' m_group '" + this.m_group + "'"));
            match = false;
            unmatch.add(new String(s_msgBundle.getMessage("5182", false) + ": " + Found + "'" + usmDev.getGroup() + "' " + Expected + "'" + this.m_group + "'"));
        }
        if (Integer.parseInt(usmDev.getPerms(), 8) != Integer.parseInt(this.m_perms, 8)) {
            Trace.out((int)5, (String)("Perms NOT equal: usmDev '" + usmDev.getPerms() + "' m_perms '" + this.m_perms + "'"));
            match = false;
            unmatch.add(new String(s_msgBundle.getMessage("5183", false) + ": " + Found + "'" + usmDev.getPerms() + "' " + Expected + "'" + this.m_perms + "'"));
        }
        return match;
    }

    private String getUSMDevPerms() {
        return VerificationUtil.getDefaultUSMDevPerms();
    }

    private boolean getUdevAttributes(String[] nodeList, ResultSet resultSet) {
        int i;
        Trace.out((int)2, (String)"Entry");
        VerificationCommand[] udevCmdArray = new VerificationCommand[nodeList.length];
        String[] udevPaths = new String[this.m_UdevCheckFileSystems.length];
        String udevList = null;
        Trace.out((int)5, (String)("Node List to udevCommand " + Arrays.asList(nodeList)));
        if (this.m_UdevCheckPaths != null && this.m_UdevCheckPaths.length != 0) {
            for (i = 0; i < this.m_UdevCheckPaths.length; ++i) {
                udevPaths[i] = this.m_UdevCheckPaths[i].replaceFirst("/dev/", "");
            }
        } else {
            for (i = 0; i < this.m_UdevCheckFileSystems.length; ++i) {
                udevPaths[i] = this.m_UdevCheckFileSystems[i].replaceFirst("/dev/", "");
            }
        }
        udevList = VerificationUtil.strArr2List(udevPaths);
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nm_UdevCheckPaths: " + VerificationUtil.strArr2List(this.m_UdevCheckPaths) + "\nm_UdevCheckFileSystems: " + VerificationUtil.strArr2List(this.m_UdevCheckFileSystems) + "\nudevList: " + udevList + "\n"));
        }
        for (int j = 0; j < nodeList.length; ++j) {
            String[] arg = null;
            String[] env = null;
            if (this.isUSMUDevCheck()) {
                arg = new String[]{"-getusmdevinfo", udevList};
                Trace.out((int)5, (String)(" Get usm device info command args: (Node: " + nodeList[j] + ") " + Arrays.asList(arg)));
            } else {
                arg = new String[]{"-getudevinfo", udevList};
                Trace.out((int)5, (String)(" Get udev info command args: " + Arrays.asList(arg)));
            }
            udevCmdArray[j] = new VerificationCommand(nodeList[j], arg, env);
        }
        new GlobalHandler().submit((Command[])udevCmdArray, 0, resultSet);
        if (!resultSet.anySuccess()) {
            Trace.out((int)5, (String)"Global failure executing getusmdevinfo command. ");
            String message = s_msgBundle.getMessage("5187", true);
            ErrorDescription errorDesc = new ErrorDescription(message);
            resultSet.addErrorDescription(nodeList, errorDesc);
            ReportUtil.printError(message);
            this.m_resultSet.addResult(nodeList, 2);
            return false;
        }
        Trace.out((int)5, (String)("Process output from " + nodeList.length + " nodes."));
        for (int nodeIndex = 0; nodeIndex < nodeList.length; ++nodeIndex) {
            VerificationCommand udevCmd = udevCmdArray[nodeIndex];
            String node = udevCmd.getNode();
            Result result = udevCmd.getResult();
            Trace.out((int)5, (String)("\n Processing node: " + node + "\n VfyCode: " + udevCmd.getVfyCode() + "\n Status: " + result.getStatus() + "\n"));
            if (udevCmd.getVfyCode() == 0 && result.getStatus() == 1) {
                String output = udevCmd.getOutput();
                Vector<USMDevInfo> usmdevVect = new Vector<USMDevInfo>();
                this.parseUsmDevCmdOutput(output, usmdevVect, node);
                result.addResultInfo(usmdevVect);
                Trace.out((int)5, (String)("Output from get udev usm command is =" + output));
                for (USMDevInfo usmdevtrace : usmdevVect) {
                    Trace.out((String)("USMDevInfo: " + usmdevtrace.toString()));
                }
                continue;
            }
            Trace.out((int)5, (String)("\n Result data:\n " + result.traceResultInfo() + "\n"));
            String message = s_msgBundle.getMessage("9802", true, (Object[])new String[]{node});
            String errmsg = udevCmd.getError();
            ErrorDescription errorDesc = null;
            if (errmsg != null) {
                Trace.out((int)5, (String)("\n Error msg: " + errmsg + "\n"));
                errorDesc = new ErrorDescription(message + VerificationConstants.LINE_SEPARATOR + errmsg);
                ReportUtil.printError(message + VerificationConstants.LINE_SEPARATOR + errmsg);
            } else {
                Trace.out((int)5, (String)"\n Error msg is NULL");
                errorDesc = new ErrorDescription(message);
                ReportUtil.printError(message);
            }
            resultSet.addErrorDescription(node, errorDesc);
            resultSet.getResult(node).setStatus(3);
        }
        resultSet.setStatus();
        return true;
    }

    public void parseUsmDevCmdOutput(String output, Vector<USMDevInfo> usmdevVect, String node) {
        Vector usmDevStr = null;
        try {
            usmDevStr = GenericUtil.getAllStrByTags(output, TAG_USMDEV);
        }
        catch (ParsingException e) {
            Trace.out((int)5, (String)("Error parsing device command output:" + usmDevStr));
            this.m_resultSet.addResult(node, 2);
            this.m_resultSet.getResult(node).setHasResultValues(true);
            this.m_resultSet.getResult(node).setActualValue(usmDevStr.toString() + e);
            this.m_resultSet.setStatus();
        }
        if (usmDevStr.size() > 0) {
            for (int i = 0; i < usmDevStr.size(); ++i) {
                String strUDEV = (String)usmDevStr.get(i);
                Trace.out((int)5, (String)("Device String [" + i + "]=" + strUDEV));
                if (strUDEV.indexOf("#") != -1 && strUDEV.indexOf("#") < strUDEV.indexOf("KERNEL")) {
                    Trace.out((int)5, (String)("COMMENT CHAR BEFORE DATA, SKIPPING:\n " + strUDEV));
                    continue;
                }
                boolean ret = false;
                USMDevInfo usminfo = null;
                try {
                    usminfo = new USMDevInfo();
                    ret = usminfo.parse((String)usmDevStr.get(i));
                }
                catch (USMDevInfoException e) {
                    Trace.out((int)5, (String)("Error parsing the following output on node " + node + ": \"" + (String)usmDevStr.get(i) + "\""));
                }
                if (ret) {
                    Trace.out((int)5, (String)("Adding new USMDevInfo to node vector" + usminfo.toString()));
                    usmdevVect.add(usminfo);
                    continue;
                }
                Trace.out((int)5, (String)("Error parsing the following output on node " + node + ": \"" + (String)usmDevStr.get(i) + "\""));
            }
            Vector<USMDevInfo> udevVect_nodupes = new Vector<USMDevInfo>();
            ArrayList<String> udevLines = new ArrayList<String>();
            USMDevInfo usmDev = null;
            for (int k = 0; k < usmdevVect.size(); ++k) {
                usmDev = usmdevVect.get(k);
                if (!(udevLines.contains(usmDev.getDevLine()) || usmDev.getDevLine().indexOf(35) != -1 && usmDev.getDevLine().indexOf("KERNEL") >= usmDev.getDevLine().indexOf(35))) {
                    Trace.out((String)("Adding usmDev to list: \n" + usmDev.getDevLine()));
                    udevVect_nodupes.add(usmDev);
                    udevLines.add(usmDev.getDevLine());
                    continue;
                }
                Trace.out((String)("Removing duplicate/commented udev entry for: \n" + usmDev.getDevLine()));
            }
            usmdevVect.clear();
            usmdevVect.addAll(udevVect_nodupes);
        }
    }

    public void setOwner(String owner) {
        this.m_owner = owner;
    }

    public void setGroup(String group1) {
        this.m_group = group1;
    }

    public void setPerms(String perms) {
        this.m_perms = perms;
    }

    public void setUSMUDevCheck() {
        this.m_stEntity = StorageEntity.USM;
    }

    public void setOCRUDevCheck() {
        this.m_stEntity = StorageEntity.OCR;
    }

    public void setVDiskUDevCheck() {
        this.m_stEntity = StorageEntity.VDISK;
    }

    public void setASMDiskUDevCheck() {
        this.m_stEntity = StorageEntity.ASM;
    }

    public boolean isUSMUDevCheck() {
        return this.m_stEntity == StorageEntity.USM;
    }

    public boolean isOCRUDevCheck() {
        return this.m_stEntity == StorageEntity.OCR;
    }

    public boolean isVDiskUDevCheck() {
        return this.m_stEntity == StorageEntity.VDISK;
    }

    public boolean isASMDiskUDevCheck() {
        return this.m_stEntity == StorageEntity.ASM;
    }

    public void setUdevCheckPaths(String[] udevCheckPaths) {
        this.m_UdevCheckPaths = udevCheckPaths;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4449", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4499", false);
    }

    public static String getVDiskOwner() {
        Result result;
        String localNode;
        try {
            localNode = VerificationUtil.getLocalHost();
            result = new Result(localNode);
        }
        catch (UnknownHostException e) {
            Trace.out((String)("Couldn't get vdisk owner: " + e.getMessage()));
            return null;
        }
        return VerificationUtil.getCRSUser(localNode, result, false);
    }

    public String getVDiskGroup() {
        return VerificationUtil.getOraInventoryGroup();
    }

    public String getOCRGroup() {
        return VerificationUtil.getOraInventoryGroup();
    }

    public void setASMDiskOwner(String asmDiskOwner) {
        this.m_asmDiskOwner = asmDiskOwner;
    }

    public String getASMDiskOwner() {
        return this.m_asmDiskOwner;
    }

    public void setASMDiskGroup(String asmDiskGroup) {
        this.m_asmDiskGroup = asmDiskGroup;
    }

    public String getASMDiskGroup() {
        return this.m_asmDiskGroup;
    }

    public void setASMDiskPermissions(String asmDiskPermissions) {
        this.m_asmDiskPermissions = asmDiskPermissions;
    }

    public String getASMDiskPermissions() {
        return this.m_asmDiskPermissions;
    }

    @Override
    public NodeRoleCapability getApplicableNodeRoleCapability() {
        return NodeRoleCapability.HUB_CAPABLE;
    }

    private static enum StorageEntity {
        USM,
        OCR,
        VDISK,
        ASM;

    }
}

